/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.Locale;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public class CameraSystem {
    public static JSONCameraObject activeCamera;
    private static boolean nightVisionEnabled;
    private static float currentFOV;
    private static float currentMouseSensitivity;
    public static String customCameraOverlay;
    private static final Point3D cameraOffset;
    private static final RotationMatrix riderOrientation;
    private static final JSONPotionEffect NIGHT_VISION_CAMERA_POTION;

    public static boolean adjustCamera(IWrapperPlayer player, Point3D cameraAdjustedPosition, RotationMatrix cameraRotation, float partialTicks) {
        AEntityB_Existing ridingEntity = player.getEntityRiding();
        PartSeat sittingSeat = ridingEntity instanceof PartSeat ? (PartSeat)ridingEntity : null;
        EntityPlayerGun playerGunEntity = EntityPlayerGun.playerClientGuns.get(player.getID());
        AEntityF_Multipart cameraProvider = sittingSeat != null ? sittingSeat : playerGunEntity;
        CameraSystem.resetCameraProperties();
        if (nightVisionEnabled) {
            player.removePotionEffect(NIGHT_VISION_CAMERA_POTION);
            nightVisionEnabled = false;
        }
        customCameraOverlay = null;
        activeCamera = null;
        if (cameraProvider != null && (activeCamera = cameraProvider.activeCamera) != null) {
            AnimationSwitchbox switchbox = cameraProvider.activeCameraSwitchbox;
            String string = customCameraOverlay = CameraSystem.activeCamera.overlay != null ? CameraSystem.activeCamera.overlay + ".png" : null;
            if (CameraSystem.activeCamera.fovOverride != 0.0f) {
                if (currentFOV == 0.0f) {
                    currentFOV = InterfaceManager.clientInterface.getFOV();
                }
                InterfaceManager.clientInterface.setFOV(CameraSystem.activeCamera.fovOverride);
            }
            if (CameraSystem.activeCamera.mouseSensitivityOverride != 0.0f) {
                if (currentMouseSensitivity == 0.0f) {
                    currentMouseSensitivity = InterfaceManager.clientInterface.getMouseSensitivity();
                }
                InterfaceManager.clientInterface.setMouseSensitivity(CameraSystem.activeCamera.mouseSensitivityOverride);
            }
            cameraAdjustedPosition.set(CameraSystem.activeCamera.pos);
            if (switchbox != null) {
                switchbox.runSwitchbox(partialTicks, false);
                cameraAdjustedPosition.transform(switchbox.netMatrix);
            }
            cameraProvider.activeCameraEntity.getInterpolatedOrientation(cameraRotation, partialTicks);
            cameraAdjustedPosition.rotate(cameraRotation);
            if (switchbox != null) {
                cameraRotation.multiply(switchbox.rotation);
            }
            if (CameraSystem.activeCamera.rot != null) {
                cameraRotation.multiply(CameraSystem.activeCamera.rot);
            }
            cameraOffset.set(cameraProvider.activeCameraEntity.prevPosition).interpolate(cameraProvider.activeCameraEntity.position, partialTicks);
            cameraAdjustedPosition.add(cameraOffset);
            if (CameraSystem.activeCamera.nightVision) {
                player.addPotionEffect(NIGHT_VISION_CAMERA_POTION);
                nightVisionEnabled = true;
            }
            return true;
        }
        if (sittingSeat != null) {
            cameraAdjustedPosition.set(sittingSeat.prevRiderCameraPosition).interpolate(sittingSeat.riderCameraPosition, partialTicks);
            sittingSeat.getInterpolatedOrientation(cameraRotation, partialTicks);
            sittingSeat.getRiderInterpolatedOrientation(riderOrientation, partialTicks);
            cameraRotation.multiply(riderOrientation);
            return true;
        }
        return false;
    }

    public static void resetCameraProperties() {
        if (currentFOV != 0.0f) {
            InterfaceManager.clientInterface.setFOV(currentFOV);
            currentFOV = 0.0f;
        }
        if (currentMouseSensitivity != 0.0f) {
            InterfaceManager.clientInterface.setMouseSensitivity(currentMouseSensitivity);
            currentMouseSensitivity = 0.0f;
        }
    }

    static {
        cameraOffset = new Point3D();
        riderOrientation = new RotationMatrix();
        NIGHT_VISION_CAMERA_POTION = new JSONPotionEffect();
        CameraSystem.NIGHT_VISION_CAMERA_POTION.duration = 300;
        CameraSystem.NIGHT_VISION_CAMERA_POTION.name = JSONPotionEffect.PotionDefaults.NIGHT_VISION.name().toLowerCase(Locale.ROOT);
    }

    public static enum CameraMode {
        FIRST_PERSON(false),
        THIRD_PERSON(true),
        THIRD_PERSON_INVERTED(true);

        public final boolean thirdPerson;

        private CameraMode(boolean thirdPerson) {
            this.thirdPerson = thirdPerson;
        }
    }
}

